//
//  XMLParser.m
//  Axis
//
//  Created by Olivier Savard on 10-03-01.
//  Copyright 2010 OSInfo Informatique. All rights reserved.
//

#import "XMLParser.h"
#import "NewsController.h"
#import "Nouvelle.h"
#import "AxisAppDelegate.h"

@implementation XMLParser

- (XMLParser *) initXMLParser {
	
	[super init];
	
	appDelegate = (AxisAppDelegate *)[[UIApplication sharedApplication] delegate];
	
	return self;
}

- (void)parser:(NSXMLParser *)parser didStartElement:(NSString *)elementName
  namespaceURI:(NSString *)namespaceURI qualifiedName:(NSString *)qualifiedName
	attributes:(NSDictionary *)attributeDict {
	
	if([elementName isEqualToString:@"nouvelles"]) {
		//Initialize the array.
		appDelegate.listeNouvelles = [[NSMutableArray alloc] init];
	}
	else if([elementName isEqualToString:@"nouvelle"]) {
		//Initialize the book.
		uneNouvelle = [[Nouvelle alloc] init];
		
		//Extract the attribute here.
		uneNouvelle.no = [[attributeDict objectForKey:@"id"] integerValue];
		uneNouvelle.titre = [attributeDict objectForKey:@"titre"];
		uneNouvelle.detail = [attributeDict objectForKey:@"detail"];
		
		//aBook.bookID = [[attributeDict objectForKey:@"id"] integerValue];
		//aBook.title = [attributeDict objectForKey:@"title"];
		//aBook.summary = [attributeDict objectForKey:@"summary"];
		
		/*TESTS
		NSString *texte=[[NSString alloc]initWithFormat:@"%i",uneNouvelle.no];
		uneNouvelle.titre=texte;
		uneNouvelle.detail=texte;
		
		NSLog(@"Lecture de l'element NO :%i", uneNouvelle.no);
		NSLog(@"et de Detail : %@",uneNouvelle.detail);
		NSLog(@"Lecture de l'element de titre :%@", uneNouvelle.titre);
		NSLog(@"et de Detail : %@",uneNouvelle.detail);*/
	}
	
	NSLog(@"Processing Element: %@", elementName);
}

- (void)parser:(NSXMLParser *)parser foundCharacters:(NSString *)string {
	
	if(!currentElementValue)
		currentElementValue = [[NSMutableString alloc] initWithString:string];
	else
		[currentElementValue appendString:string];
	
	NSLog(@"Processing Value: %@", currentElementValue);
	
}

- (void)parser:(NSXMLParser *)parser didEndElement:(NSString *)elementName
  namespaceURI:(NSString *)namespaceURI qualifiedName:(NSString *)qName {
	
	if([elementName isEqualToString:@"nouvelles"])
		return;
	
	//There is nothing to do if we encounter the Books element here.
	//If we encounter the Book element howevere, we want to add the book object to the array
	// and release the object.
	if([elementName isEqualToString:@"nouvelle"]) {
		//test
		NSLog(@"titre avant ajout: %@",uneNouvelle.titre);
		
		
		[appDelegate.listeNouvelles addObject:uneNouvelle];
		
		/*TESTS
		
		NSString *texte=[[NSString alloc] init];
		Book *news=[[Book alloc]init];
		NSArray *array=[[NSArray alloc] init];
		array = appDelegate.books;
		news=[array objectAtIndex:0];
		texte=news.title;
		NSLog(@"Detail PROVENANT DUNE COPIE DE LA LISTENOUVELLES:%@",texte);
		[texte release];
		NSLog(@"A");
		[news release];
		NSLog(@"B");
		//fin test */
		
		
		NSLog(@"C");
		aBook = nil;
	}
	else
		[uneNouvelle setValue:currentElementValue forKey:elementName];
	
	[currentElementValue release];
	currentElementValue = nil;
}

- (void) dealloc {
	
	[uneNouvelle release];
	[currentElementValue release];
	[super dealloc];
}

@end
