//
//  NewsController.m
//  Axis
//
//  Created by Olivier Savard on 10-02-26.
//  Copyright 2010 OSInfo Informatique. All rights reserved.
//

#import "NewsController.h"
#import "NewsDetailController.h"
#import "XMLParser.h"
#import "AxisAppDelegate.h"
#import "Nouvelle.h";
#import "AsyncImageView.h"
#import "CustomCell.h"


@implementation NewsController

@synthesize listeNouvelles;


/*
- (id)initWithStyle:(UITableViewStyle)style {
    // Override initWithStyle: if you create the controller programmatically and want to perform customization that is not appropriate for viewDidLoad.
    if (self = [super initWithStyle:style]) {
    }
    return self;
}
*/




- (void)viewDidLoad {
    /*
	self.title=@"Nouvelles";
	NSArray *array2 = [[NSArray alloc] initWithObjects:@"Nouvelles",nil];
	self.listeNouvelles = array2;
	[array2 release];
	 */
	AxisAppDelegate * appDelegate = (AxisAppDelegate *)[[UIApplication sharedApplication] delegate];
	self.listeNouvelles=appDelegate.listeNouvelles;
	
	
	
	/*
	//BOOKS
	self.books = appDelegate.books;
	Book *aBook = [[Book alloc] init];
	aBook = [self.books objectAtIndex:0];
	NSLog(@"%i",aBook.bookID);
	*/
}



- (void)viewWillAppear:(BOOL)animated {
	[self.tableView reloadData];
    [super viewWillAppear:animated];
}

/*
- (void)viewDidAppear:(BOOL)animated {
    [super viewDidAppear:animated];
}
*/
/*
- (void)viewWillDisappear:(BOOL)animated {
	[super viewWillDisappear:animated];
}
*/
/*
- (void)viewDidDisappear:(BOOL)animated {
	[super viewDidDisappear:animated];
}
*/

/*
// Override to allow orientations other than the default portrait orientation.
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation {
    // Return YES for supported orientations
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}
*/

- (void)didReceiveMemoryWarning {
	// Releases the view if it doesn't have a superview.
    [super didReceiveMemoryWarning];
	
	// Release any cached data, images, etc that aren't in use.
}

- (void)viewDidUnload {
	// Release any retained subviews of the main view.
	// e.g. self.myOutlet = nil;
}


#pragma mark Table view methods

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}


// Customize the number of rows in the table view.
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return listeNouvelles.count;
}


// Customize the appearance of table view cells.
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    
	//acces aux settings
	NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
	
    static NSString *CustomCellIdentifier = @"CustomCellIdentifier";
    
    CustomCell *cell = (CustomCell *)[tableView dequeueReusableCellWithIdentifier:CustomCellIdentifier];
    if (cell == nil) {
        NSArray *nib = [[NSBundle mainBundle] loadNibNamed:@"CustomCell" owner:self options:nil];
		for (id oneObject in nib)
			if ([oneObject isKindOfClass:[CustomCell class]])
				cell = (CustomCell *)oneObject;
		
    }
	else {
		AsyncImageView* oldImage = (AsyncImageView*)[cell.img viewWithTag:999];
		[oldImage removeFromSuperview];
	}
	NSInteger lignes = [defaults floatForKey:@"nbrLignes"];
	NSInteger height = ((12-lignes) * 16);
	cell.frame=CGRectMake(0, 0, 320, height);
	
				
	// Set up the cell...
	//NOUVELLE
	NSString *texte = [NSString alloc];
	NSUInteger row = indexPath.row;
	Nouvelle *uneNouvelle = [[[Nouvelle alloc]init]autorelease];
	uneNouvelle = [listeNouvelles objectAtIndex:row];
	cell.titre.frame = CGRectMake(height*1.5+5, 0, 320-(height*1.5+20), height*0.5);
	cell.detail.frame = CGRectMake(height*1.5+5, height*0.5, 320-(height*1.5+20),height*0.5);
	cell.titre.text = uneNouvelle.titre;
	cell.detail.text = uneNouvelle.detail;
	cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
	
	//CODE AJOUTE POUR ASYNC IMAGE
	CGRect frame;
	frame.size.width=height*1.5; frame.size.height=height;
	frame.origin.x=0; frame.origin.y=0;
	AsyncImageView* asyncImage = [[[AsyncImageView alloc] initWithFrame:frame]autorelease];
	asyncImage.tag = 999;
	NSString *stringUrl = [[NSString alloc] initWithFormat:@"http://www.web-k.org/os/imgs/%i.jpg",uneNouvelle.no];
	NSURL *url = [NSURL URLWithString:stringUrl];
	
	
	
	[asyncImage loadImageFromURL:url];
	[cell.img addSubview:asyncImage];
	
	

	
	
	
	//ORIGINAL
	//[asyncImage loadImageFromURL:url];
	//[cell.contentView addSubview:asyncImage];

	
	[texte release];
    [stringUrl release];
	return cell;
}


- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    // Navigation logic may go here. Create and push another view controller.
	// AnotherViewController *anotherViewController = [[AnotherViewController alloc] initWithNibName:@"AnotherView" bundle:nil];
	// [self.navigationController pushViewController:anotherViewController];
	// [anotherViewController release];
	NewsDetailController *detailNews = [[[NewsDetailController alloc] initWithNibName:@"NewsDetailController" bundle:nil]autorelease];
	detailNews.title=self.title;
	NSUInteger row = indexPath.row;
	Nouvelle *uneNouvelle = [listeNouvelles objectAtIndex:row];
	detailNews.no=uneNouvelle.no; 
	detailNews.texte=uneNouvelle.detail;
	[self.navigationController pushViewController:detailNews animated:YES];
}

-(CGFloat)tableView:(UITableView *)tableView 
heightForRowAtIndexPath:(NSIndexPath *)indexPath {
	NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
	NSInteger lignes = [defaults floatForKey:@"nbrLignes"];
	NSInteger height = ((12-lignes) * 16);
	return height;
}



- (void)dealloc {
    [listeNouvelles release];
	[super dealloc];
}

#pragma mark -
#pragma mark Table Delegate	Methods

-(NSInteger)tableView:(UITableView *)tableView
indentationLevelForRowAtIndexPath:(NSIndexPath *)indexPath {
	return 20;
}




@end

