//
//  MapViewController.m
//  Axis
//
//  Created by Olivier Savard on 10-02-26.
//  Copyright 2010 OSInfo Informatique. All rights reserved.
//

#import "MapViewController.h"
#import "MapLocation.h"
#import <MapKit/MapKit.h>



@implementation MapViewController
@synthesize map;
@synthesize mapType;
@synthesize button;

/*
 // The designated initializer.  Override if you create the controller programmatically and want to perform customization that is not appropriate for viewDidLoad.
- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil {
    if (self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil]) {
        // Custom initialization
    }
    return self;
}
*/

/*
// Implement loadView to create a view hierarchy programmatically, without using a nib.
- (void)loadView {
}
*/


// Implement viewDidLoad to do additional setup after loading the view, typically from a nib.
- (void)viewDidLoad {
	map.showsUserLocation = YES;
	map.mapType = MKMapTypeStandard;
	map.delegate = self;
	
	
	
	/*Region and Zoom*/
	MKCoordinateRegion region;
	MKCoordinateSpan span;
	span.latitudeDelta=1;
	span.longitudeDelta=1;
	
	CLLocationCoordinate2D location=map.userLocation.coordinate;
	
		
	location.latitude=45.794796;
	location.longitude=-73.998413;
	region.span=span;
	region.center=location;
	
	[map setRegion:region animated:TRUE];
	[map regionThatFits:region];

	/*
	//Premier magasin
	MapLocation *annotation = [[MapLocation alloc] init];
	annotation.title=@"Olivier";
	annotation.rue=@"250 56e avenue";
	annotation.ville=@"Pointe-Calumet";
	annotation.province=@"Quebec";
	locate.latitude = 45.494796;
	locate.longitude = -73.998413;
	annotation.coordinate = locate;

	[map addAnnotation:annotation];
	
	[annotation release];*/
	
	//Deuxieme magasin
	MapLocation *annotation2 = [[MapLocation alloc] init];
	annotation2.title=@"Axis Avila";
	annotation2.rue=@"500, chemin Avila";
	annotation2.ville=@"Piedmont";
	annotation2.province=@"Québec";
	locate.latitude = 45.886553;
	locate.longitude = -74.133878;
	annotation2.coordinate = locate;

	[map addAnnotation:annotation2];
	
	[annotation2 release];
	
	
	
	//troisieme magasin
	MapLocation *annotation3 = [[MapLocation alloc] init];
	annotation3.title=@"Axis Laval";
	annotation3.rue=@"850 boul. Le Corbusier";
	annotation3.ville=@"Laval";
	annotation3.province=@"Québec";
	locate.latitude = 45.556039;
	locate.longitude = -73.723636;
	annotation3.coordinate = locate;
	
	[map addAnnotation:annotation3];
	
	[annotation3 release];
	
	//4e magasin
	MapLocation *annotation4 = [[MapLocation alloc] init];
	annotation4.title=@"Axis Ste-Dorothée";
	annotation4.rue=@"2356, Autoroute Chomedey Laval";
	annotation4.ville=@"Ste-Dorothée";
	annotation4.province=@"Québec";
	locate.latitude = 45.563798;
	locate.longitude = -73.819784;
	annotation4.coordinate = locate;
	
	[map addAnnotation:annotation4];
	
	[annotation4 release];
	
	//5e magasin
	MapLocation *annotation5 = [[MapLocation alloc] init];
	annotation5.title=@"Axis St-Zotique";
	annotation5.rue=@"511 34e Ave.";
	annotation5.ville=@"St-Zotique";
	annotation5.province=@"Québec";
	locate.latitude = 45.248178;
	locate.longitude = -74.250292;
	annotation5.coordinate = locate;
	
	[map addAnnotation:annotation5];

	[annotation5 release];
	
	//6e magasin
	MapLocation *annotation6 = [[MapLocation alloc] init];
	annotation6.title=@"Axis Tremblant";
	annotation6.rue=@"300 route 117";
	annotation6.ville=@"Mont-Tremblant";
	annotation6.province=@"Québec";
	locate.latitude = 46.116689;
	locate.longitude = -74.563355;
	annotation6.coordinate = locate;
	
	[map addAnnotation:annotation6];
	
	[annotation6 release];
	
	//7e magasin
	MapLocation *annotation7 = [[MapLocation alloc] init];
	annotation7.title=@"Axis Val d'Ord";
	annotation7.rue=@"820 4e avenue";
	annotation7.ville=@"Val d'Or";
	annotation7.province=@"Québec";
	locate.latitude = 48.103913;
	locate.longitude = -77.786905;
	annotation7.coordinate = locate;
	
	[map addAnnotation:annotation7];
	
	[annotation7 release];
	
	//NSArray *array = [[NSArray alloc] initWithObjects:annotation,annotation2,annotation3,annotation4,annotation5,annotation6,annotation7];
	//[map addAnnotations:array];
    [super viewDidLoad];
}

- (MKAnnotationView *) mapView:(MKMapView *)theMapView viewForAnnotation:(id <MKAnnotation>)annotation {
	static NSString *placemarkIdentifier = @"Map Location Identifier";
	if ([annotation isKindOfClass:[MapLocation class]]) {
		MKPinAnnotationView *annotationView = (MKPinAnnotationView *) [theMapView dequeueReusableAnnotationViewWithIdentifier:placemarkIdentifier];
		if (annotationView == nil) {
			annotationView = [[MKPinAnnotationView alloc] initWithAnnotation:annotation reuseIdentifier:placemarkIdentifier];
		}
		else {
			annotation.annotation = annotation;
		}
		annotationView.enabled = YES;
		annotationView.animatesDrop = YES;
		annotationView.pinColor = MKPinAnnotationColorPurple;
		annotationView.canShowCallout = YES;
		//[self performSelector:@selector(openCallout:) withObject:annotation afterDelay:0.5];
		
		return annotationView;
	}
	return nil;
}

/*
// Override to allow orientations other than the default portrait orientation.
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation {
    // Return YES for supported orientations
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}
*/

- (void)didReceiveMemoryWarning {
	// Releases the view if it doesn't have a superview.
    [super didReceiveMemoryWarning];
	
	// Release any cached data, images, etc that aren't in use.
}

- (void)viewDidUnload {
	// Release any retained subviews of the main view.
	// e.g. self.myOutlet = nil;
	self.map = nil;
}


- (void)dealloc {
	[map release];
    [super dealloc];
}

- (IBAction)changeType:(id)sender{
	if(mapType.selectedSegmentIndex==0){
		map.mapType=MKMapTypeStandard;
	}
	else if (mapType.selectedSegmentIndex==1){
		map.mapType=MKMapTypeSatellite;
	}
	else if (mapType.selectedSegmentIndex==2){
		map.mapType=MKMapTypeHybrid;
	}
}

-(IBAction)center{
	MKCoordinateRegion region;
	MKCoordinateSpan span;
	span.latitudeDelta=1;
	span.longitudeDelta=1;
	
	CLLocationCoordinate2D location=map.userLocation.coordinate;
	
	
	location.latitude=45.794796;
	location.longitude=-73.998413;
	region.span=span;
	region.center=location;
	
	[map setRegion:region animated:TRUE];
	[map regionThatFits:region];
}


@end
