//
//  MapLocation.m
//  Axis
//
//  Created by Olivier Savard on 10-02-26.
//  Copyright 2010 OSInfo Informatique. All rights reserved.
//

#import "MapLocation.h"
#import <MapKit/MapKit.h>


@implementation MapLocation
@synthesize rue;
@synthesize ville;
@synthesize province;
@synthesize codePostal;
@synthesize title;
@synthesize coordinate;

#pragma mark -

 -(NSString *)title {
	return title;
}

-(NSString *)subtitle {
	NSMutableString *ret = [NSMutableString string];
	if(rue)
		[ret appendString:rue];
	if(rue && (ville || province || codePostal))
		[ret appendString:@", "];
	if (ville)
		[ret appendString:ville];
	if (ville && province)
		[ret appendString:@", "];
	if (province)
		[ret appendString:province];
	if (codePostal){
		[ret appendString:@", "];
		[ret appendString:codePostal];
	}
	return ret;
}

#pragma mark -
-(void) dealloc {
	[rue release];
	[ville release];
	[province release];
	[super dealloc];
}
#pragma mark NSCoding Methods

-(void)encodeWithCoder:(NSCoder *)encoder{
	[encoder encodeObject:[self rue] forKey: @"rue"];
	[encoder encodeObject:[self ville] forKey: @"ville"];
	[encoder encodeObject:[self province] forKey: @"province"];
	[encoder encodeObject:[self codePostal] forKey: @"codePostal"];
}

-(id)initWithCoder:(NSCoder *)decoder{
	if (self = [super init]) {
		[self setRue:[decoder decodeObjectForKey:@"rue"]];
		[self setVille:[decoder decodeObjectForKey:@"ville"]];
		[self setProvince:[decoder decodeObjectForKey:@"province"]];
		[self setCodePostal:[decoder decodeObjectForKey:@"codePostal"]];
	}
	return self;
}

@end
