//
//  AsyncImageView.h
//  Axis
//
//  Created by Olivier Savard on 10-03-04.
//  Copyright 2010 OSInfo Informatique. All rights reserved.
//

#import <UIKit/UIKit.h>


@interface AsyncImageView : UIImageView {
	//could instead be a subclass of UIImageView instead of UIView, depending on what other features you want to 
	// to build into this class?
	
	NSURLConnection* connection; //keep a reference to the connection so we can cancel download in dealloc
	NSMutableData* data; //keep reference to the data so we can collect it as it downloads
	UIActivityIndicatorView *spinner;
	BOOL	downloaded;
	//but where is the UIImage reference? We keep it in self.subviews - no need to re-code what we have in the parent class
	
}
@property (nonatomic,retain) IBOutlet UIActivityIndicatorView *spinner;
- (void)loadImageFromURL:(NSURL*)url;
- (UIImage*) image;

@end